<%@ Control Language="c#" AutoEventWireup="false" Codebehind="ManageDictionaries.ascx.cs" Inherits="Mediachase.UI.Web.Admin.Modules.ManageDictionaries" TargetSchema="http://schemas.microsoft.com/intellisense/ie5"%>
<%@ Register TagPrefix="ibn" TagName="BlockHeader" src="..\..\Modules\BlockHeader.ascx" %>
<TABLE class="ibn-stylebox2 text" cellSpacing="0" cellPadding="0" width="100%" border="0">
	<tr>
		<td><ibn:blockheader id="secHeader" runat="server" /></td>
	</tr>
	<tr>
		<td class="ibn-navline ibn-alternating text" style="PADDING:14px">
			<%=LocRM.GetString("SelectDictionary") %>:&nbsp;
			<asp:DropDownList Width="200px" id="ddDictionaries" runat="server" AutoPostBack="True"></asp:DropDownList>
			<asp:Button CssClass="text" ID="btnAddNewItem" Runat="server" CausesValidation="False" style="display:none"></asp:Button>
			<asp:Label Runat="server" ID="lblError" CssClass="ibn-error"></asp:Label>
		</td>
	</tr>
	<tr>
		<td>
			<asp:DataGrid id="dgDic" runat="server" cellpadding="1" gridlines="Horizontal" borderwidth="0" autogeneratecolumns="False" width="100%" allowsorting="False">
				<Columns>
					<asp:BoundColumn Visible="False" DataField="ItemId" ReadOnly="True"></asp:BoundColumn>
					<asp:TemplateColumn>
						<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%# DataBinder.Eval(Container.DataItem,"ItemName") %>
						</ItemTemplate>
						<EditItemTemplate>
							<asp:TextBox ID="tbName" Text='<%# DataBinder.Eval(Container.DataItem,"ItemName") %>' CssClass="text" Width="100%" Runat="server">
							</asp:TextBox>
							<asp:RequiredFieldValidator ID="rfName" ControlToValidate="tbName" ErrorMessage='<%#LocRM.GetString("Required") %>' Display="Dynamic" Runat="server"/>
						</EditItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn>
						<headerstyle cssclass="ibn-vh2" Width="80"></headerstyle>
						<itemstyle cssclass="ibn-vb2" Width="80"></itemstyle>
						<ItemTemplate>
							<%# DataBinder.Eval(Container.DataItem,"Weight") %>
						</ItemTemplate>
						<EditItemTemplate>
							<asp:TextBox ID="tbWeight" Text='<%# DataBinder.Eval(Container.DataItem,"Weight") %>' CssClass="text" Width="60px" Runat="server"></asp:TextBox>
							<asp:RangeValidator ID="rvWeight" ErrorMessage="*" CssClass="text" Runat=server ControlToValidate="tbWeight" Display=Dynamic MinimumValue="0" MaximumValue="1000" Type=Integer></asp:RangeValidator>
						</EditItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn>
						<headerstyle cssclass="ibn-vh2" Width="50"></headerstyle>
						<itemstyle cssclass="ibn-vb2" Width="50"></itemstyle>
						<itemtemplate>
							<asp:imagebutton id="ibMove" runat="server" borderwidth="0" title='<%# LocRM.GetString("Edit")%>' imageurl="../../layouts/images/Edit.gif" commandname="Edit" causesvalidation="False">
							</asp:imagebutton>
							&nbsp;&nbsp;
							<asp:imagebutton id="ibDelete" runat="server" borderwidth="0" title='<%# LocRM.GetString("Delete")%>' imageurl="../../layouts/images/Delete.gif" commandname="Delete" causesvalidation="False" Visible='<%# GetVisibleStatus(DataBinder.Eval(Container.DataItem,"CanDelete")) %>' >
							</asp:imagebutton>
						</itemtemplate>
						<EditItemTemplate>
							<asp:imagebutton id="Imagebutton1" runat="server" borderwidth="0" title='<%# LocRM.GetString("Save")%>' imageurl="../../layouts/images/Saveitem.gif" commandname="Update" causesvalidation="True">
							</asp:imagebutton>
							&nbsp;&nbsp;
							<asp:imagebutton id="Imagebutton2" runat="server" borderwidth="0" imageurl="../../layouts/images/cancel.gif" title='<%# LocRM.GetString("Cancel")%>' commandname="Cancel" causesvalidation="False">
							</asp:imagebutton>
						</EditItemTemplate>
					</asp:TemplateColumn>
				</Columns>
			</asp:DataGrid>
		</td>
	</tr>
</TABLE>
